//********************************************************************;
//*                                                                  *;
//*  Intel(R) Confidential                                           *;
//*                                                                  *;
//*  TXTINFO64   Tool                                                *;
//*                                                                  *;
//*  Copyright (c) 2009 Intel Corp.                                  *;
//*                                                                  *;
//*  This code has been developed by Intel Corporation.              *;
//*  Licensee has Intel's permission to incorporate this source code *;
//*  into their product, royalty free.  This source code may NOT be  *;
//*  redistributed to anyone without Intel's written permission.     *;
//*                                                                  *;
//*  Intel specifically disclaims all warranties, express or         *;
//*  implied, and all liability, including consequential and other   *;
//*  indirect damages, for the use of this code, including liability *;
//*  for infringement of any proprietary rights, and including the   *;
//*  warranties of merchantability and fitness for a particular      *;
//*  purpose.  Intel does not assume any responsibility for any      *;
//*  errors which may appear in this code nor any responsibility to  *;
//*  update it.                                                      *;
//*                                                                  *;
//********************************************************************;

#include "Uefi.h"
#include "Uefilib.h"

#include "OutputFormat.h"
//#include "CmdLineOptions.h"
//extern CMD_LINE_OPTIONS gsCmdLineOptions;
extern EFI_SYSTEM_TABLE   *gST;

/* depricated 
void ScreenLine(int iLineCnt)
{		
	UINT32	r;
	EFI_INPUT_KEY          Key;
	UINT32  Attr;
	static UINT32 scrln;
	if(gsCmdLineOptions.u8PauseOutputFlag){
		r = scrln % 22;
		scrln += iLineCnt;
		if ((scrln % 22 == 0) || (scrln % 22 < r)){
			Attr = gST->ConOut->Mode->Attribute;
			norColor;
			Print(L"--more--\n");             
			color(Attr);
			scrln++;
			while(gST->ConIn->ReadKeyStroke(gST->ConIn,&Key) != EFI_SUCCESS);
		}
	}
}
*/
/************************************************/
void DumpHexValue (CHAR16 *pMsgStr, UINT8 *pu8Source, UINT32 u32DataSize)
{
	UINT32 u32ByteCntr;

	Print(L"%s\n", pMsgStr);
	for (u32ByteCntr = 0; u32ByteCntr < u32DataSize; u32ByteCntr++){
		Print(L"%02x ", *(pu8Source + u32ByteCntr));
		if (!((u32ByteCntr+1)%16)){
			Print(L"\n");
		}
	}

	Print(L"\n");
}

void PadSpace(CHAR16 * strSource, UINT32 u32PadLen)
{
	UINT32 u32SourcLen, i;

	u32SourcLen = StrLen(strSource);
	if (u32SourcLen >= u32PadLen){
		return;
	}
	for (i=0; i < (u32PadLen - u32SourcLen); i++){
		strSource[u32SourcLen + i] = L' ';
	}				 
	strSource[u32SourcLen + i] = 0;
}

/*-----------------------------------------------------------------------------
Procedure:	
Input:	pByte - pointer to byte array, that is to be dumped
u32ByteCnt - total byte count in pByte
u32BytePerRowCnt - Number of bytes per row
u32SpcShftRow1   - Space shift for row 1
u32SpcShftRowOtr - Space shift for rows other than row 1
*/
void DumpBinary(UINT8 *pByte, UINT32 u32ByteCnt, UINT32 u32BytePerRowCnt, UINT32 u32SpcShftRow1, UINT32 u32SpcShftRowOtr) 
{
	UINT32	u32ByteIdx, u32ColumnIdx;
	CHAR16	ch16Temp[80];

	for (u32ByteIdx=0, u32ColumnIdx = 0 ; u32ByteIdx < u32ByteCnt; u32ByteIdx++, u32ColumnIdx++) {
		/*Print first byte after u32SpcShftRow1 spaces*/
		if (0 == u32ByteIdx){
			ch16Temp[0]=0;
			PadSpace(ch16Temp, (UINT32) u32SpcShftRow1);
			Print(L"%s%02X", ch16Temp, *(pByte + u32ByteIdx));
		}
		else {                         
			if (u32ColumnIdx != u32BytePerRowCnt){
				/*If in the midle of the row - print with a space before.*/
				Print(L" %02X", *(pByte + u32ByteIdx));
			}
			else {                                                          
				/* If at the boundary - CRLF then print with shftn before and 
				   reset u32ColumnIdx*/
				Print(L"\n"); 
				u32ColumnIdx = 0;
				ch16Temp[0] = 0;
				PadSpace(ch16Temp, (UINT32) u32SpcShftRowOtr);
				Print(L"%s%02X", ch16Temp, *(pByte + u32ByteIdx));
			}       
		}
	}
	Print(L"\n");
}
